/*
 * Decompiled with CFR 0.152.
 */
package knight37x.lance.network;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.EnumMap;
import java.util.HashMap;
import knight37x.lance.network.BasicHandler;
import knight37x.lance.network.NetworkBase;
import net.minecraft.entity.player.EntityPlayerMP;

@ChannelHandler.Sharable
public class PacketHandler
extends SimpleChannelInboundHandler<FMLProxyPacket> {
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private static HashMap<Integer, NetworkBase> handlers = new HashMap();

    protected void channelRead0(ChannelHandlerContext ctx, FMLProxyPacket packet) throws Exception {
        if (packet.channel().equals("lance")) {
            try {
                ByteBuf payload = packet.payload();
                int packetID = payload.readInt();
                handlers.get(packetID).handle(payload, packetID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean registerHandler(int packetID, NetworkBase handler) {
        if (handlers.containsKey(packetID)) {
            return false;
        }
        handlers.put(packetID, handler);
        return true;
    }

    public static int getFreePacketID() {
        int i = 0;
        while (handlers.containsKey(i)) {
            ++i;
        }
        return i;
    }

    public void initialise() {
        this.channels = NetworkRegistry.INSTANCE.newChannel("lance", new ChannelHandler[]{this});
        BasicHandler handler = new BasicHandler();
        handlers.put(0, handler);
        handlers.put(1, handler);
        handlers.put(2, handler);
        handlers.put(3, handler);
        handlers.put(10, handler);
        handlers.put(11, handler);
        handlers.put(12, handler);
        handlers.put(13, handler);
    }

    public void sendToAll(FMLProxyPacket message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendTo(FMLProxyPacket message, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToAllAround(FMLProxyPacket message, NetworkRegistry.TargetPoint point) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToDimension(FMLProxyPacket message, int dimensionId) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToServer(FMLProxyPacket message) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)message);
    }
}

