/*
 * Decompiled with CFR 0.152.
 */
package knight37x.lance;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import knight37x.lance.EventHookContainer;
import knight37x.lance.LanceAutoUpdate;
import knight37x.lance.Version;
import knight37x.lance.block.BlockBowConfig;
import knight37x.lance.block.GuiHandler;
import knight37x.lance.entity.EntitySpear;
import knight37x.lance.item.ItemLanceCopper;
import knight37x.lance.item.ItemLanceDiamond;
import knight37x.lance.item.ItemLanceIron;
import knight37x.lance.item.ItemLanceSteel;
import knight37x.lance.item.ItemLanceUp;
import knight37x.lance.item.ItemMayorBow;
import knight37x.lance.item.ItemShaft;
import knight37x.lance.item.ItemSks;
import knight37x.lance.item.ItemSpear;
import knight37x.lance.item.ItemSpearFire;
import knight37x.lance.item.ItemSpearPoison;
import knight37x.lance.item.ItemSpearTNT;
import knight37x.lance.network.PacketHandler;
import knight37x.lance.proxies.LanceCommonProxy;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(modid="lance", name="Lance Mod", version="2.6.1.1710")
public class Lance {
    public static final String modid = "lance";
    public static final String name = "Lance Mod";
    public static final String version = "2.6.1.1710";
    @Mod.Instance(value="lance")
    public static Lance instance = new Lance();
    @SidedProxy(clientSide="knight37x.lance.proxies.LanceClientProxy", serverSide="knight37x.lance.proxies.LanceCommonProxy")
    public static LanceCommonProxy proxy;
    public static final PacketHandler packetHandler;
    public static final EventHookContainer eventHandler;
    public static CreativeTabs tabLance;
    public static Version newestVersion;
    public static Item lanceOnIron;
    public static Item lanceUpIron;
    public static Item lanceOnDia;
    public static Item lanceUpDia;
    public static Item lanceOnCopper;
    public static Item lanceUpCopper;
    public static Item lanceOnSteel;
    public static Item lanceUpSteel;
    public static Item shaft;
    public static Item mayorBow;
    public static Block bowConfig;
    public static Item wood_sks;
    public static Item stone_sks;
    public static Item iron_sks;
    public static Item gold_sks;
    public static Item diamond_sks;
    public static Item spear;
    public static Item spearTNT;
    public static Item spearPoison;
    public static Item spearFire;
    public static Item diamondRipper;
    public static Item ironRipper;
    public static Item copperRipper;
    public static Item steelRipper;
    public static boolean sksOnBlocks;
    public static boolean craftableSaddle;
    public static boolean shouldLanceBreak;
    private int numberOfHits = 500;
    public static boolean shouldTakeDamageFromArmour;
    public static int armorBehaviour;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        new Version.NewVersion().start();
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        craftableSaddle = config.get("general", "Saddle craftable", true).getBoolean(true);
        sksOnBlocks = config.get("general", "Self-Knockback-Sword usable on Blocks (Fast travelling)", false).getBoolean(false);
        shouldLanceBreak = config.get("general", "Should the lance take damage?", true).getBoolean(true);
        shouldTakeDamageFromArmour = config.get("general", "Should the lance take more damage when hitting an armoured mob?", true).getBoolean(true);
        this.numberOfHits = config.get("general", "How often you can hit a mob until the lance will break (Iron Lance)", 1500).getInt();
        armorBehaviour = config.get("general", "Armour rating to instantly break a lance <settable to any value between 0 and 20 with increments of 0.5>", 5).getInt() * 2;
        if (armorBehaviour > 20) {
            armorBehaviour = 20;
        } else if (armorBehaviour < 0) {
            armorBehaviour = 0;
        }
        config.save();
        lanceOnIron = new ItemLanceIron().func_77655_b("lanceI").func_77625_d(1).func_77656_e(this.numberOfHits).func_111206_d("lance:lanceIron");
        lanceUpIron = new ItemLanceUp(lanceOnIron, "Iron").func_77655_b("lanceUpI").func_77625_d(1).func_77656_e(this.numberOfHits).func_111206_d("lance:lanceIron");
        lanceOnDia = new ItemLanceDiamond().func_77655_b("lanceD").func_77625_d(1).func_77656_e(this.numberOfHits * 6).func_111206_d("lance:lanceDiamond");
        lanceUpDia = new ItemLanceUp(lanceOnDia, "Diamond").func_77655_b("lanceUpD").func_77625_d(1).func_77656_e(this.numberOfHits * 6).func_111206_d("lance:lanceDiamond");
        shaft = new ItemShaft().func_77637_a(tabLance).func_77655_b("shaft").func_111206_d("lance:lanceShaft");
        mayorBow = new ItemMayorBow().func_77637_a(tabLance).func_77655_b("mayorBow").func_111206_d("lance:mayorBow_standby").func_77625_d(1);
        bowConfig = new BlockBowConfig(Material.field_151575_d).func_149663_c("bowConfig").func_149658_d("lance:bowConfig").func_149647_a(tabLance).func_149672_a(Blocks.field_150462_ai.field_149762_H);
        wood_sks = new ItemSks(Item.ToolMaterial.WOOD, "lance:wood_sks").func_111206_d("wood_sword").func_77655_b("wood_sks").func_77637_a(null);
        stone_sks = new ItemSks(Item.ToolMaterial.STONE, "lance:stone_sks").func_111206_d("stone_sword").func_77655_b("stone_sks").func_77637_a(null);
        iron_sks = new ItemSks(Item.ToolMaterial.IRON, "lance:iron_sks").func_111206_d("iron_sword").func_77655_b("iron_sks").func_77637_a(null);
        gold_sks = new ItemSks(Item.ToolMaterial.GOLD, "lance:gold_sks").func_111206_d("gold_sword").func_77655_b("gold_sks").func_77637_a(null);
        diamond_sks = new ItemSks(Item.ToolMaterial.EMERALD, "lance:diamond_sks").func_111206_d("diamond_sword").func_77655_b("diamond_sks").func_77637_a(null);
        wood_sks = new ItemSks(Item.ToolMaterial.WOOD, "lance:wood_sks").func_111206_d("wood_sword").func_77655_b("wood_sks");
        stone_sks = new ItemSks(Item.ToolMaterial.STONE, "lance:stone_sks").func_111206_d("stone_sword").func_77655_b("stone_sks");
        iron_sks = new ItemSks(Item.ToolMaterial.IRON, "lance:iron_sks").func_111206_d("iron_sword").func_77655_b("iron_sks");
        gold_sks = new ItemSks(Item.ToolMaterial.GOLD, "lance:gold_sks").func_111206_d("gold_sword").func_77655_b("gold_sks");
        diamond_sks = new ItemSks(Item.ToolMaterial.EMERALD, "lance:diamond_sks").func_111206_d("diamond_sword").func_77655_b("diamond_sks");
        lanceOnCopper = new ItemLanceCopper().func_77655_b("lanceC").func_77625_d(1).func_77656_e(this.numberOfHits / 5 * 4).func_111206_d("lance:lanceCopper");
        lanceUpCopper = new ItemLanceUp(lanceOnCopper, "Copper").func_77655_b("lanceUpC").func_77625_d(1).func_77656_e(this.numberOfHits / 5 * 4).func_111206_d("lance:lanceCopper");
        lanceOnSteel = new ItemLanceSteel().func_77655_b("lanceS").func_77625_d(1).func_77656_e(this.numberOfHits * 2).func_111206_d("lance:lanceSteel");
        lanceUpSteel = new ItemLanceUp(lanceOnSteel, "Steel").func_77655_b("lanceUpS").func_77625_d(1).func_77656_e(this.numberOfHits * 2).func_111206_d("lance:lanceSteel");
        spear = new ItemSpear().func_77655_b("spear").func_77637_a(tabLance).func_111206_d("lance:spearIron").func_77625_d(16);
        spearTNT = new ItemSpearTNT().func_77655_b("spearTNT").func_77637_a(tabLance).func_111206_d("lance:spearTNT").func_77625_d(16);
        spearPoison = new ItemSpearPoison().func_77655_b("spearPoison").func_77637_a(tabLance).func_111206_d("lance:spearPoison").func_77625_d(16);
        spearFire = new ItemSpearFire().func_77655_b("spearFire").func_77637_a(tabLance).func_111206_d("lance:spearFire").func_77625_d(16);
        diamondRipper = new Item().func_111206_d("lance:diamond_ripper").func_77655_b("diamond_ripper").func_77637_a(tabLance);
        ironRipper = new Item().func_111206_d("lance:iron_ripper").func_77655_b("iron_ripper").func_77637_a(tabLance);
        copperRipper = new Item().func_111206_d("lance:copper_ripper").func_77655_b("copper_ripper").func_77637_a(tabLance);
        steelRipper = new Item().func_111206_d("lance:steel_ripper").func_77655_b("steel_ripper").func_77637_a(tabLance);
        this.registerItems();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        packetHandler.initialise();
        EntityRegistry.registerGlobalEntityID(EntitySpear.class, (String)"Spear", (int)EntityRegistry.findGlobalUniqueEntityId());
        FMLCommonHandler.instance().bus().register((Object)eventHandler);
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        this.registerRecipes();
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        ServerCommandManager manager = (ServerCommandManager)MinecraftServer.func_71276_C().func_71187_D();
        manager.func_71560_a((ICommand)new LanceAutoUpdate());
    }

    private void registerRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(shaft, new Object[]{"#  ", " # ", "  #", Character.valueOf('#'), Items.field_151055_y}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(mayorBow, new Object[]{" #S", "# S", " #S", Character.valueOf('#'), Items.field_151031_f, Character.valueOf('S'), Items.field_151007_F}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bowConfig, new Object[]{"SCS", "STS", "SBS", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('C'), Blocks.field_150462_ai, Character.valueOf('T'), Items.field_151007_F, Character.valueOf('B'), mayorBow}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(lanceUpDia, new Object[]{"  X", " # ", "#  ", Character.valueOf('#'), shaft, Character.valueOf('X'), diamondRipper}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(lanceUpIron, new Object[]{"  X", " # ", "#  ", Character.valueOf('#'), shaft, Character.valueOf('X'), ironRipper}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(lanceUpCopper, new Object[]{"  X", " # ", "#  ", Character.valueOf('#'), shaft, Character.valueOf('X'), copperRipper}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(lanceUpSteel, new Object[]{"  X", " # ", "#  ", Character.valueOf('#'), shaft, Character.valueOf('X'), steelRipper}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(spear, 4), new Object[]{"  X", " # ", "#  ", Character.valueOf('#'), Items.field_151055_y, Character.valueOf('X'), Items.field_151042_j}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(spearTNT, 1), new Object[]{"X", "#", Character.valueOf('X'), Blocks.field_150335_W, Character.valueOf('#'), spear}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(spearPoison, 1), new Object[]{"X", "#", Character.valueOf('X'), new ItemStack((Item)Items.field_151068_bn, 1, 8196), Character.valueOf('#'), spear}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(spearFire, 1), new Object[]{"X", "#", Character.valueOf('X'), new ItemStack(Items.field_151033_d, 1, Short.MAX_VALUE), Character.valueOf('#'), spear}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(Items.field_151141_av, new Object[]{"# #", "###", Character.valueOf('#'), Items.field_151116_aA}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(diamondRipper, new Object[]{" # ", "# #", Character.valueOf('#'), Items.field_151045_i}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ironRipper, new Object[]{" # ", "# #", Character.valueOf('#'), Items.field_151042_j}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(copperRipper, new Object[]{" # ", "# #", Character.valueOf('#'), "ingot_Copper"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(copperRipper, new Object[]{" # ", "# #", Character.valueOf('#'), "copper_ingot"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(steelRipper, new Object[]{" # ", "# #", Character.valueOf('#'), "ingot_Steel"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(steelRipper, new Object[]{" # ", "# #", Character.valueOf('#'), "steel_ingot"}));
    }

    private void registerItems() {
        GameRegistry.registerItem((Item)lanceOnIron, (String)"iron_lance_on");
        GameRegistry.registerItem((Item)lanceUpIron, (String)"iron_lance");
        GameRegistry.registerItem((Item)lanceOnDia, (String)"diamond_lance_on");
        GameRegistry.registerItem((Item)lanceUpDia, (String)"diamon_lance");
        GameRegistry.registerItem((Item)lanceOnSteel, (String)"steel_lance_on");
        GameRegistry.registerItem((Item)lanceUpSteel, (String)"steel_lance");
        GameRegistry.registerItem((Item)lanceOnCopper, (String)"copper_lance_on");
        GameRegistry.registerItem((Item)lanceUpCopper, (String)"copper_lance");
        GameRegistry.registerItem((Item)shaft, (String)"shaft");
        GameRegistry.registerItem((Item)mayorBow, (String)"mayorBow");
        GameRegistry.registerBlock((Block)bowConfig, (String)"bowConfig");
        GameRegistry.registerItem((Item)spear, (String)"spear");
        GameRegistry.registerItem((Item)spearTNT, (String)"spearTNT");
        GameRegistry.registerItem((Item)spearPoison, (String)"spearPoison");
        GameRegistry.registerItem((Item)spearFire, (String)"spearFire");
        GameRegistry.registerItem((Item)wood_sks, (String)"wood_sks");
        GameRegistry.registerItem((Item)stone_sks, (String)"stone_sks");
        GameRegistry.registerItem((Item)iron_sks, (String)"iron_sks");
        GameRegistry.registerItem((Item)gold_sks, (String)"gold_sks");
        GameRegistry.registerItem((Item)diamond_sks, (String)"diamond_sks");
        GameRegistry.registerItem((Item)diamondRipper, (String)"diamond_ripper");
        GameRegistry.registerItem((Item)ironRipper, (String)"iron_ripper");
        GameRegistry.registerItem((Item)copperRipper, (String)"copper_ripper");
        GameRegistry.registerItem((Item)steelRipper, (String)"steel_ripper");
    }

    static {
        packetHandler = new PacketHandler();
        eventHandler = new EventHookContainer();
        tabLance = new CreativeTabs("tabLance"){

            public Item func_78016_d() {
                return lanceUpIron;
            }
        };
        newestVersion = null;
        sksOnBlocks = false;
        craftableSaddle = true;
        shouldLanceBreak = true;
        shouldTakeDamageFromArmour = true;
        armorBehaviour = 5;
    }
}

